--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;


--
-- Release Notes
-- Version : C.0Ah
-- Updated : 2012/06/18
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ah' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='A.0Ah' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ah';


--
-- Data for Name: email_smtp_server; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE email_smtp_server ADD COLUMN connect_type integer DEFAULT 1;

--
-- Data for Name: systeminf; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE systeminf ADD COLUMN mobile_ucs_license integer NOT NULL DEFAULT 0;

--
-- Data for Name: ucuser_profile; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE ucuser_profile ADD COLUMN client_device integer DEFAULT 1;

--
-- Release Notes
-- Version : C.0Ai
-- Updated : 2012/07/05
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ai' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='A.0Ai' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ai';


--
-- Name: mobile_audio_by_model; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE mobile_audio_by_model (
    model_name character varying(80) NOT NULL,
    model_description character varying(80),
    audio_setting_mode integer DEFAULT 2 NOT NULL,
    handset_enable_ns boolean DEFAULT false,
    handset_ns_mode integer DEFAULT 3 NOT NULL,
    handset_enable_agc boolean DEFAULT false,
    handset_agc_mode integer DEFAULT 3 NOT NULL,
    handset_enable_ec boolean DEFAULT true,
    handset_ec_mode integer DEFAULT 5 NOT NULL,
    handset_aecm_mode integer DEFAULT 3 NOT NULL,
    handset_aecm_enable_cng boolean DEFAULT false,
    handset_aes_mode integer DEFAULT 1 NOT NULL,
    handset_aes_saturation integer DEFAULT 28 NOT NULL,
    speaker_enable_ns boolean DEFAULT false,
    speaker_ns_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_agc boolean DEFAULT false,
    speaker_agc_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_ec boolean DEFAULT true,
    speaker_ec_mode integer DEFAULT 4 NOT NULL,
    speaker_aecm_mode integer DEFAULT 3 NOT NULL,
    speaker_aecm_enable_cng boolean DEFAULT false,
    speaker_aes_mode integer DEFAULT 2 NOT NULL,
    speaker_aes_saturation integer DEFAULT 28 NOT NULL
);


ALTER TABLE public.mobile_audio_by_model OWNER TO postgres;

--
-- Name: mobile_audio_by_model_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY mobile_audio_by_model
    ADD CONSTRAINT mobile_audio_by_model_pkey PRIMARY KEY (model_name);


--
-- Name: mobile_audio_by_client; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE mobile_audio_by_client (
    client_key integer NOT NULL,
    audio_setting_mode integer DEFAULT 2 NOT NULL,
    handset_enable_ns boolean DEFAULT false,
    handset_ns_mode integer DEFAULT 3 NOT NULL,
    handset_enable_agc boolean DEFAULT false,
    handset_agc_mode integer DEFAULT 3 NOT NULL,
    handset_enable_ec boolean DEFAULT true,
    handset_ec_mode integer DEFAULT 5 NOT NULL,
    handset_aecm_mode integer DEFAULT 3 NOT NULL,
    handset_aecm_enable_cng boolean DEFAULT false,
    handset_aes_mode integer DEFAULT 1 NOT NULL,
    handset_aes_saturation integer DEFAULT 28 NOT NULL,
    speaker_enable_ns boolean DEFAULT false,
    speaker_ns_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_agc boolean DEFAULT false,
    speaker_agc_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_ec boolean DEFAULT true,
    speaker_ec_mode integer DEFAULT 4 NOT NULL,
    speaker_aecm_mode integer DEFAULT 3 NOT NULL,
    speaker_aecm_enable_cng boolean DEFAULT false,
    speaker_aes_mode integer DEFAULT 2 NOT NULL,
    speaker_aes_saturation integer DEFAULT 28 NOT NULL
);


ALTER TABLE public.mobile_audio_by_client OWNER TO postgres;

--
-- Name: mobile_audio_by_client_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY mobile_audio_by_client
    ADD CONSTRAINT mobile_audio_by_client_pkey PRIMARY KEY (client_key);


--
-- Name: make_mobile_audio_by_client(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION make_mobile_audio_by_client()
  RETURNS integer AS
$BODY$DECLARE
    u RECORD;
    t RECORD;
BEGIN
    FOR u IN 
	SELECT 	user_key
	FROM 	userinf
	WHERE   user_key <> 1 AND user_id <> '' AND user_id IS NOT NULL
	LOOP
		INSERT INTO mobile_audio_by_client(client_key)
		    VALUES (u.user_key);
    END LOOP; 
    RETURN 1; 
END;$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION make_mobile_audio_by_client() OWNER TO postgres;

SELECT * FROM make_mobile_audio_by_client();

--
-- Data for Name: ucuser_profile; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE ucuser_profile ADD COLUMN model_name character varying(80);


--
-- Data for Name: adminlevel; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY adminlevel (admin_menu, allowed_admin_level, admin_number) FROM stdin;
Audio Setting by Mobile Client	1	321
Audio Setting by Mobile Phone	1	322
\.


--
-- Name: create_audio_setting_by_mobile_phone(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE OR REPLACE FUNCTION create_audio_setting_by_mobile_phone()
  RETURNS integer AS
$BODY$DECLARE
    u RECORD;
    t RECORD;
BEGIN
    FOR u IN 
		SELECT DISTINCT model_name 
		FROM   ucuser_profile 
		WHERE  model_name IS NOT NULL AND 
			   model_name NOT IN ( SELECT model_name FROM mobile_audio_by_model )
		LOOP
			INSERT INTO mobile_audio_by_model(model_name, model_description)
				VALUES (u.model_name, u.model_name);
		END LOOP; 
    RETURN 1; 
END;$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION create_audio_setting_by_mobile_phone() OWNER TO postgres;

--
-- Release Notes
-- Version : 3.0Aj
-- Updated : 2012/07/09
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='3.0Aj' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Aj' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='3.0Aj';


--
-- Release Notes
-- Version : 3.0Ak
-- Updated : 2012/08/15
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='3.0Ak' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Ak' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='3.0Ak';


--
-- Data for Name: serveroamoption; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE serveroamoption ADD COLUMN on_demand_backup_request boolean DEFAULT false;


--
-- Release Notes
-- Version : 3.0Am
-- Updated : 2012/09/07
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='3.0Am' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Am' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='3.0Am';


--
-- PostgreSQL database dump complete
--